IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'dbo.CF_Cliente_Cob_Tipo_Mes')  and type = 'FN')
BEGIN
    DROP FUNCTION dbo.CF_Cliente_Cob_Tipo_Mes
END
GO



CREATE FUNCTION dbo.CF_Cliente_Cob_Tipo_Mes(@Id_Cliente INT,@Id_Tipo_Val  CHAR(3),@Flag_Grupo TINYINT,@Fecha DATETIME)
RETURNS DECIMAL(16,2)
AS
BEGIN

IF @Id_Cliente IN(0,1) RETURN 0

DECLARE @Retorno DECIMAL(16,2),
		@titular INT


IF ISNULL(@Flag_Grupo,0) <> 0
BEGIN
   SELECT @titular = ISNULL(Id_Cliente_Ref,0) FROM Clientes WHERE Id_Cliente  = @Id_Cliente
   IF @titular =  0  SET @titular = @Id_Cliente

	SELECT @Retorno = SUM(V.Importe) FROM Valores V, Valores_Mov VM ,Cbtes C, Cbtes_Tipos T 
	WHERE  C.id_Tipo_Cbte = T.Id_Tipo_Cbte
	AND T.Compromete_Recibos = 1
	AND C.Id_Estado_Cbte IN (1,2,4)
	AND ( C.id_Cliente IN (SELECT Id_Cliente FROM Clientes WHERE Id_Cliente_Ref = @titular)
	      OR  C.id_Cliente = @titular )
	AND C.Fecha >= dbo.CF_FOMONTH(@Fecha)
	AND C.Fecha <  dbo.CF_EOMONTH(@Fecha + 1)
	AND V.Id_Valor = VM.Id_Valor
	AND V.Id_Tipo_Val = @Id_Tipo_Val
	AND VM.Id_Trans = C.id_Trans
	AND VM.Renglon_Nro = (SELECT MAX(VM2.Renglon_Nro) FROM Valores_Mov VM2
							WHERE VM2.Id_Valor = VM.Id_Valor
								AND VM2.Id_Trans = C.Id_Trans)
END
ELSE
BEGIN
	SET @titular = @Id_Cliente


	SELECT @Retorno = SUM(V.Importe) FROM Valores V, Valores_Mov VM ,Cbtes C, Cbtes_Tipos T 
	WHERE  C.id_Tipo_Cbte = T.Id_Tipo_Cbte
	AND T.Compromete_Recibos = 1
	AND C.Id_Estado_Cbte IN (1,2,4)
	AND C.id_Cliente = @titular
	AND C.Fecha >= dbo.CF_FOMONTH(@Fecha)
	AND C.Fecha <  dbo.CF_EOMONTH(@Fecha + 1)
	AND V.Id_Valor = VM.Id_Valor
	AND V.Id_Tipo_Val = @Id_Tipo_Val
	AND VM.Id_Trans = C.id_Trans
	AND VM.Renglon_Nro = (SELECT MAX(VM2.Renglon_Nro) FROM Valores_Mov VM2
							WHERE VM2.Id_Valor = VM.Id_Valor
								AND VM2.Id_Trans = C.Id_Trans)

END


RETURN ISNULL(@Retorno,0)


END

